/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.client.sound;

import com.creativemd.creativecore.common.config.premade.curve.DecimalCurve;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import paulscode.sound.Library;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.Source;

public class SoundMuteHandler {
    public static boolean isMuting = false;
    public static HashMap<Source, Float> sources = null;
    public static Library soundLibrary;
    public static SoundSystem sndSystem;
    public static ArrayList<String> ignoredSounds;
    public static DecimalCurve muteGraph;
    public static int timeTick;

    public static void tick() {
        if (isMuting) {
            double factor = muteGraph.valueAt((double)timeTick);
            if (factor <= 0.0) {
                SoundMuteHandler.endMuting();
            } else {
                SoundMuteHandler.setMuteVolume((float)(1.0 - factor));
                ++timeTick;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSounds() {
        try {
            HashMap sourcesAndIDs = null;
            Iterator iterator = SoundSystemConfig.THREAD_SYNC;
            synchronized (iterator) {
                sourcesAndIDs = new HashMap(soundLibrary.getSources());
            }
            for (Source source : sourcesAndIDs.values()) {
                if (sources.containsKey(source) || ignoredSounds.contains(source.sourcename)) continue;
                sources.put(source, Float.valueOf(source.sourceVolume));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean startMuting(DecimalCurve muteGraph) {
        if (soundLibrary == null) {
            SoundHandler handler = Minecraft.func_71410_x().func_147118_V();
            SoundManager sndManager = (SoundManager)ReflectionHelper.getPrivateValue(SoundHandler.class, (Object)handler, (String[])new String[]{"sndManager", "field_147694_f"});
            sndSystem = (SoundSystem)ReflectionHelper.getPrivateValue(SoundManager.class, (Object)sndManager, (String[])new String[]{"sndSystem", "field_148620_e"});
            soundLibrary = (Library)ReflectionHelper.getPrivateValue(SoundSystem.class, (Object)sndSystem, (String[])new String[]{"soundLibrary"});
        }
        if (isMuting && SoundMuteHandler.muteGraph.valueAt((double)timeTick) > muteGraph.valueAt(0.0)) {
            SoundMuteHandler.muteGraph = muteGraph;
            timeTick = 0;
            SoundMuteHandler.tick();
            return true;
        }
        if (!isMuting) {
            SoundMuteHandler.muteGraph = muteGraph;
            timeTick = 0;
            ignoredSounds = new ArrayList();
            isMuting = true;
            SoundMuteHandler.tick();
            return true;
        }
        return false;
    }

    public static void endMuting() {
        SoundMuteHandler.setMuteVolume(1.0f);
        sources = null;
        isMuting = false;
        ignoredSounds = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void setMuteVolume(float muteVolume) {
        if (isMuting && sources != null) {
            Object object = SoundSystemConfig.THREAD_SYNC;
            synchronized (object) {
                for (Source source : sources.keySet()) {
                    sndSystem.setVolume(source.sourcename, sources.get(source).floatValue() * muteVolume);
                }
            }
        }
    }

    static {
        timeTick = 0;
    }
}

